-- HL pickup with DShK

GT = {};
GT_t.ws = 0;
set_recursive_metatable(GT, GT_t.generic_wheel_vehicle);
set_recursive_metatable(GT.chassis, GT_t.CH_t.bhd_somali_pickup_chassis);
GT.chassis.mass = GT.chassis.mass + 80;   --1740=1660+80kg DShK

GT.visual.shape = "bhd_somali_pickup_pkm";	
GT.visual.shape_dstr = "tt70_p_1";

GT.animation_arguments.pitch_k = 1.5;
GT.animation_arguments.roll_k = 1.5;

GT.IR_emission_coeff = 0.08

GT.swing_on_run = false;

GT.sensor = {};
set_recursive_metatable(GT.sensor, GT_t.SN_visual);
GT.sensor.height = 2.826;

GT.windscreen_wiper = 40
GT.animation_arguments.crew_presence = 50;

--destruction  
GT.agony_fire_pos_y = 0.982;
GT.agony_fire_pos_y = 1.725;
GT.agony_fire_pos_z = 0.315;

--Burning after hit
GT.visual.fire_size = 0.65; --relative burning size
GT.visual.fire_pos[1] = 0.2; -- center of burn at long axis shift(meters)
GT.visual.fire_pos[2] = 0.8; -- center of burn shift at vertical shift(meters)
GT.visual.fire_pos[3] = 0; -- center of burn at transverse axis shift(meters)
GT.visual.fire_time = 300; --burning time (seconds)
GT.visual.min_time_agony = 1;
GT.visual.max_time_agony = 5;
GT.visual.agony_explosion_size = 1;

GT.visual.IR = { coeffs = {GT_t.IR_COEFFS_ENGINE_APC, GT_t.IR_COEFFS_WHEELS_Car, GT_t.IR_COEFFS_HMG, GT_t.IR_COEFFS_BODY, {0.21, 0.21/1050}}}

GT.driverCockpit = "DriverCockpit/DriverCockpit"
GT.driverViewConnectorName = "POINT_DRIVER"

-- weapon systems
GT.WS = {};
GT.WS.maxTargetDetectionRange = 2000;
GT.WS.fire_on_march = true;

ws = GT_t.inc_ws();
GT.WS[ws] = {};
GT.WS[ws].center = 'POINT_TOWER';
GT.WS[ws].cockpit = { "IronSight/IronSight", open = true};
GT.WS[ws].pointer = "POINT_SIGHT"
GT.WS[ws].angles = {
					 {math.rad(30), math.rad(-30), math.rad(-17), math.rad(40)},		-- main
                    {math.rad(-30), math.rad(30), math.rad(-12), math.rad(40)},		-- roof sector
					};
GT.WS[ws].drawArgument1 = 0;
GT.WS[ws].drawArgument2 = 1;
GT.WS[ws].omegaY = math.rad(100);
GT.WS[ws].omegaZ = math.rad(100);
GT.WS[ws].pidY = {p=100,i=1.5,d=9,inn=10};
GT.WS[ws].pidZ = {p=100,i=1.5,d=9,inn=10,};

__LN = add_launcher(GT.WS[ws], GT_t.LN_t.AK74);
__LN.maxShootingSpeed = 0;
for i=2,20 do -- 20 clips, 600 rounds
	__LN.PL[i] = {};
	set_recursive_metatable(__LN.PL[i], __LN.PL[1]);
end
__LN.fireAnimationArgument = 23;
__LN.BR[1].connector_name = 'POINT_GUN';
--__LN.BR[1].pos = {0.9, 0.4, 0.2}
__LN.connectorFire = false;


GT.Name = "bhd_somali_pickup_pkm";
GT.DisplayName = _("BHD - Somali Pickup PKM");
GT.DisplayNameShort = _("PckpPKM");
GT.Rate = 6;
GT.Crew = 2;

GT.DetectionRange  = GT.sensor.max_range_finding_target;
--GT.airWeaponDist = 0
GT.ThreatRange = GT.WS[1].LN[1].distanceMax;
GT.mapclasskey = "P0091000004";
GT.attribute = {wsType_Ground, wsType_Tank, wsType_Gun, WSTYPE_PLACEHOLDER,
                "APC",
                };
GT.category = "Armor"
GT.tags  =
{
   "Armor",
   "Scout/Recon",
}
